<?php
/* Funciones para mi theme */

/******** SECCIONES - CPT***********/
require_once dirname( __FILE__ ) . '/secciones/herrera_opciones.php';
require_once dirname( __FILE__ ) . '/secciones/pages.php';
require_once dirname( __FILE__ ) . '/secciones/banner_cpt.php';
require_once dirname( __FILE__ ) . '/secciones/productos_cpt.php';
require_once dirname( __FILE__ ) . '/secciones/logros_cpt.php';
require_once dirname( __FILE__ ) . '/secciones/compromiso_ambiental_cpt.php';
/********END**SECCIONES - CPT*********/

/******** Inicio Registro para los menus de navegacion del sitio ********/
register_nav_menus( array(
    'primary' => __( 'Primary Menú', '' ), 
    /*'footer' => __( 'Site Map', '' ),*/
    /*'secondary'  => __( 'Secondary Menú', '' ),*/
    ));
/******** END Registro menus ********/


/******** Inicio funciones para los wigets del sitio********/
function _widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Sidebar1', '' ),
		'id'            => 'sidebar-1',
		'description'   => __( 'Agregar modulos a la barra lateral', '' ),
		'before_widget' => '<widget id="%1$s" class="widget %2$s">',
		'after_widget'  => '</widget>',
		'before_title'  => '<h4 class="widget_title">',
		'after_title'   => '</h4>',
	) );

	
}
add_action( 'widgets_init', '_widgets_init' );
/******** END wigets ********/


/******** Inicio Deteccion de javascript  ********/
function jg_javascript_detection() {
	echo "<script>(function(html){html.className = html.className.replace(/\bno-js\b/,'js')})(document.documentElement);</script>\n";
}
add_action( 'wp_head', 'jg_javascript_detection', 0 );
/******** END Deteccion de javascript  ********/


/******** Inicio Scripts ********/
function jg_scripts() {
	// Theme stylesheet.
	wp_enqueue_style( 'jg-style', get_stylesheet_uri() );

	// Load the Internet Explorer specific stylesheet.
	wp_enqueue_style( 'jg-ie', get_template_directory_uri() . '/css/ie.css', array( 'jg-style' ), '20160816' );
	wp_style_add_data( 'jg-ie', 'conditional', 'lt IE 10' );

	// Load the Internet Explorer 8 specific stylesheet.
	wp_enqueue_style( 'jg-ie8', get_template_directory_uri() . '/css/ie8.css', array( 'jg-style' ), '20160816' );
	wp_style_add_data( 'jg-ie8', 'conditional', 'lt IE 9' );

	// Load the Internet Explorer 7 specific stylesheet.
	wp_enqueue_style( 'jg-ie7', get_template_directory_uri() . '/css/ie7.css', array( 'jg-style' ), '20160816' );
	wp_style_add_data( 'jg-ie7', 'conditional', 'lt IE 8' );

	// Load the html5 shiv.
	wp_enqueue_script( 'jg-html5', get_template_directory_uri() . '/js/html5.js', array(), '3.7.3' );
	wp_script_add_data( 'jg-html5', 'conditional', 'lt IE 9' );
}
add_action( 'wp_enqueue_scripts', 'jg_scripts' );
/******** END Scripts ********/


add_theme_support( 'post-thumbnails' );


/******** Inicio Registrar CSS ********/
function blog_css() {?> 
    <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('stylesheet_directory');?>/css/bootstrap.min.css" >
    <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('stylesheet_directory');?>/css/globales.css">
    <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('stylesheet_directory');?>/css/full-slider.css">
    <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('stylesheet_directory');?>/css/font-awesome.min.css"/>
    <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('stylesheet_directory');?>/css/animate.css">
    <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('stylesheet_directory');?>/css/hover.css"> 
    <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('stylesheet_directory');?>/css/jquery-ui.css">
    <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo("stylesheet_directory");?>/css/slick.css"> 
    <link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo("stylesheet_directory");?>/css/slick-theme.css"> 
<?php }
add_action('wp_head', 'blog_css');
/******** END CSS ********/


/******** Inicio Registrar JS ********/
function blog_js(){?>
	<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
	<![endif]-->
    
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    	<!--[if lt IE 9]>
         	<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
        	<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
		<![endif]-->  
	<!-- js  --> 

    <!-- JS -->
       	<!-- <script src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script> -->
        <script type="text/javascript" src="<?php echo get_bloginfo('stylesheet_directory');?>/js/jquery.min.js"></script>
        <script type="text/javascript" src="<?php echo get_bloginfo('stylesheet_directory');?>/js/jquery-ui.js"></script>
        <script type="text/javascript" src="<?php echo get_bloginfo('stylesheet_directory');?>/js/wow.min.js"></script>
        <script type="text/javascript" src="<?php echo get_bloginfo('stylesheet_directory');?>/js/funciones-java.js"></script>
        <script type="text/javascript" src="<?php echo get_bloginfo('stylesheet_directory');?>/js/jquery.form.js"></script>
        <script type="text/javascript" src="<?php echo get_bloginfo('stylesheet_directory');?>/js/jquery.validate.js"></script>
        <script type="text/javascript" src="<?php echo get_bloginfo("stylesheet_directory");?>/js/slick.js"></script>
        <script type="text/javascript" src="<?php echo get_bloginfo("stylesheet_directory");?>/js/tabcollapse.js"></script>
    <!-- JS -->
<?php } 


add_action('wp_head', 'blog_js');
/******** END JS ********/


/******** Inicio No barra superior ********/
add_filter( 'show_admin_bar', '__return_false' );
/******** END barra superior ********/


/******** Inicio Registrar favicon usuarios********/
function favicon() {
    $favicon = get_theme_mod("favicon");

    echo "<link rel='Shortcut Icon' type='image/x-icon' href='".$favicon."'></link>"; 
}
add_action('wp_head', 'favicon');
add_action('admin_head', 'favicon');
/******** END favicon ********/


/******** Inicio Detectar el slug de un post o pagina ********/
function the_slug($echo=true){
    $slug = basename(get_permalink());
    do_action('before_slug', $slug);
    $slug = apply_filters('slug_filter', $slug);
    if( $echo ) echo $slug;
    do_action('after_slug', $slug);
    return $slug;
}
/******** END Detectar el slug de un post o pagina ********/


/******** Inicio Basura del Head ********/
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'feed_links', 2);
remove_action('wp_head', 'index_rel_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'feed_links_extra', 3);
remove_action('wp_head', 'start_post_rel_link', 10, 0);
remove_action('wp_head', 'parent_post_rel_link', 10, 0);
remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0);
/******** END Basura del Head ********/


/******** Inicio Función para imprimir imagen destacada ********/
function destacada() {
    global $post;
    $thumbID = get_post_thumbnail_id( $post->ID );
    $imgDestacada = wp_get_attachment_image_src( $thumbID, 'full' ); // Sustituir por thumbnail, medium, large o full

    /******** Inicio validar si hay imagen destacada ********/
    if (empty($imgDestacada)) {
        $img = "images/not-found.jpg";
        return  get_template_directory_uri()."/".$img;
    }
    /******** END Inicio validar si hay imagen destacada ********/
    
    return $imgDestacada[0]; // 0 = ruta, 1 = altura, 2 = anchura, 3 = boolean
}
/******** END Función para imprimir imagen destacada ********/


/******** Inicio Funcion para imprimir subcategorias ********/
function subcategorias(){
$cat_id = get_query_var('cat');
$catlist = get_categories('hide_empty=0&child_of='.$cat_id);?>
    <nav id="menu_categories">
        <ul>
            <?php  
                foreach($catlist as $categories_item)
            {?>
            <li><a href="<?php echo get_category_link( $categories_item->term_id );?>"><?php echo $categories_item->name; ?></a></li>
            <?php } ?>
        </ul>
    </nav>
<?php  }
/******** END Funcion para imprimir subcategorias ********/


/******** Inicio Shared Compartir ********/
function shared_article() {?>
	<nav class="shared">
		<h5>Comparte este artículo</h5>
		<ul>
            <li><a href="http://www.facebook.com/sharer.php?u=<?php the_permalink(); ?>&t=<?php the_title();?>&m=<?php echo destacada();?>"   target="_blank"><i class="fa fa-facebook"></i></a></li>
            <li><a href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title_attribute(); ?>"  target="_blank"><i class="fa fa-twitter"></i></a></li>
            <li><a href="https://plus.google.com/share?url=<?php the_permalink(); ?>"  target="_blank"><i class="fa fa-google-plus"></i></a></li>
            <?php $pin_imagen = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'large' ); ?>
            <li><a href="https://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo $pin_imagen[0]; ?>"  target="_blank"><i class="fa fa-pinterest"></i></a></li>
		</ul>
	</nav>
<?php } 
/******** END Shared Compartir ********/


/******** Inicio Funcion Paginador ********/
function pagination($pages = '', $range = 2){  
    $showitems = ($range * 2)+1;  
    global $paged;
        if(empty($paged)) $paged = 1;
        if($pages == ''){
            global $wp_query;
            $pages = $wp_query->max_num_pages;
            if(!$pages){
                $pages = 1;
            }
        }   
    if(1 != $pages){
        echo "<nav id='pagination'>";
            echo "<ul>";
                if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<li><a href='".get_pagenum_link(1)."'>Inicio</a></li>";
                if($paged > 1 && $showitems < $pages) echo "<li><a href='".get_pagenum_link($paged - 1)."'><i class='fa fa-angle-double-left' aria-hidden='true'></i></a><li>";
                for ($i=1; $i <= $pages; $i++){
                    if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
                        echo ($paged == $i)? "<li><span class='current'>".$i."</span></li>":"<li><a href='".get_pagenum_link($i)."' class='inactive' >".$i."</a></li>";
                    }
                }
                if ($paged < $pages && $showitems < $pages) echo "<li><a href='".get_pagenum_link($paged + 1)."'><i class='fa fa-angle-double-right' aria-hidden='true'></i></a></li>";  
                if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<li><a href='".get_pagenum_link($pages)."'>Fin</a></li>";
            echo "</ul>";
        echo "</nav>";
    }
}
add_theme_support('category-thumbnails');
/******** END Funcion paginador ********/


/******** Inicio Funcion para el extracto ********/
add_post_type_support('page', 'excerpt');

function get_excerpt($count){  
    $excerpt = get_the_content();  
    $excerpt = strip_tags($excerpt);  
    $excerpt = substr($excerpt, 0, $count);  
    $excerpt = substr($excerpt, 0, strripos($excerpt, " "));  
    return $excerpt;
}
/******** END Funcion para el extracto ********/


/******** Inicio Funcion para eliminar las entradas o los comentarios ********/
add_action( 'admin_menu', 'apk_eliminar_admin_menu_links' );
 

function apk_eliminar_admin_menu_links() {
    //remove_menu_page('edit.php'); // Removemos el ítem Entradas
    remove_menu_page('edit-comments.php'); // Removemos el ítem comentarios
}
/******** END Funcion para eliminar las entradas o los comentarios ********/


// function resumen(){
//     $extracto=get_the_excerpt(); $cant= strlen ($extracto);$resumen=substr(get_the_excerpt(),0,250);
//     if($cant > 250 ){
//         echo '<p>'.$resumen.'</p>';
       
//     }else{
//         echo '<p>'.$extracto.'</p>'; 
//     }                    
// }

// resumen
function excerpt($limit) {
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    if(count($excerpt)>=$limit) {
        array_pop($excerpt);
        $excerpt = implode(" ",$excerpt).' [...]';
    }else{
        $excerpt = implode(" ",$excerpt);
    } 
    // $excerpt = preg_replace('`\[[^\]]*\]`','',$excerpt);
    return $excerpt;
}

// contenido
function content($limit) {
    $content = explode(' ', get_the_content(), $limit);
    if (count($content)>=$limit) {
        array_pop($content);
        $content = implode(" ",$content).' [...]';
    }else{
        $content = implode(" ",$content);
    }  
    // $content = preg_replace('/\[.+\]/','', $content);
    $content = apply_filters('the_content', $content); 
    $content = str_replace(']]>', ']]&gt;', $content);
    return $content;
}

// limitar palabras
function limit_words( $str, $num, $append_str='' ) {
    $palabras = preg_split( '/[\s]+/', $str, -1, PREG_SPLIT_OFFSET_CAPTURE );
    if( isset($palabras[$num][1]) ){
        $str = substr( $str, 0, $palabras[$num][1] ) . $append_str;
    }
    unset( $palabras, $num );
    return trim( $str );
}

/********** Inicio Funcion add_editor = agregar el editor en las taxonomias y poder subir las imagens  *********/
function add_editor() {
    wp_editor( $content, 'myeditor' );
}
add_action('tipos-productos_edit_form_fields', 'add_editor');
/********** END Funcion add_editor *********/


function add_color_picker($hook) {
    if(is_admin()) { 
        // agregar el archivo css       
        wp_enqueue_script('wp-color-picker');
        //Incluya nuestro archivo jQuery personalizado con la dependencia de WordPress Color Picker
        wp_enqueue_style('wp-color-picker');   
    }
}
add_action('admin_enqueue_scripts', 'add_color_picker');


/******** Inicio Funcion para agregar la biblioteca de medios en wp_customize ********/
function javascript_mediaelement() {
    wp_register_script('mediaelement', plugins_url('wp-mediaelement.min.js', __FILE__), array('jquery'), '4.8.2', true);
    wp_enqueue_script('mediaelement');
}
add_action('wp_enqueue_scripts', 'javascript_mediaelement', 100);
/******** END Funcion para agregar la biblioteca de medios en wp_customize ********/

/******** Inicio Funcion para agregar la galeria javascript ********/
wp_enqueue_script('jquery-ui-sortable');
/******** END Funcion para agregar agregar la galeria javascript ********/

/******** Inicio Editor clasico ********/
add_filter('use_block_editor_for_post_type', '__return_false', 100);
/******** Fin Editor clasico ********/

/******** Inicio Funcion para deshabilitar actualizacion de un plugin ********/
function disable_plugin_updates($value){
    unset($value->response['responsive-lightbox/responsive-lightbox.php']);
    return $value;
}
add_filter('site_transient_update_plugins','disable_plugin_updates');
/******** Fin Funcion para deshabilitar actualizacion de un plugin ********/