<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>
        <?php if (is_home () ) { 
            echo bloginfo('name'); echo ' | '; bloginfo('description'); }
            elseif ( is_category() ) { single_cat_title(); echo ' | ' ; echo bloginfo('name'); }
            elseif ( is_tax() ) { single_term_title(); echo ' | ' ; echo bloginfo('name'); }
            elseif ( is_post_type_archive() ) { post_type_archive_title(); echo ' | ' ; echo bloginfo('name'); }
            elseif (is_single() || is_page()) { single_post_title(); echo ' | ' ; echo bloginfo('name'); }
            else { wp_title('',true); } ?>
    </title>
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
    <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <?php endif; ?>
    <?php wp_head(); ?>
    <?php echo get_theme_mod('analytics_code');?> 
</head>

<body id="top">
    <?php 
        $url_linea_transparencia = get_theme_mod("url_linea_transparencia");
        $img_linea_transparencia = get_theme_mod("img_linea_transparencia");
    ?>
    <div class="content_transparencia">
        <a href=" <?php echo $url_linea_transparencia; ?>" target="_blank">
            <figure>
                <img src="<?php echo $img_linea_transparencia; ?>" class="img-responsive img-circle" alt="linea_transparencia" title="linea_transparencia">
            </figure>
        </a>
    </div>
    <div id="content_top">
    	<div class="container" style="padding: 0 30px;">
	        <div class="row">
	            <div class="col-xs-12 col-sm-6 col-md-6 no_padding">
	            	<div class="row">
		                <div class="col-xs-6 col-sm-6 col-md-6  text-left no_padding">
		                	<img src="<?php echo get_bloginfo("stylesheet_directory");?>/images/icono-telefono-cordarien.png" class="img-responsive iconos_top">
		                	<a href="tel:+6048293232">+57 (604) 8293232</a>
		                </div>
		                <div class="col-xs-6 col-sm-6 col-md-6  text-left no_padding">
		                	<img src="<?php echo get_bloginfo("stylesheet_directory");?>/images/icono-correo-cordarien.png" class="img-responsive iconos_top">
		                	<a href="mailto:info@cordarien.co">info@cordarien.com.co</a>
		                </div>
	                </div>
	            </div>
	            <div class="col-xs-12 col-sm-6 col-md-6 no_padding">
	            	<div class="row">
		                <div class="col-xs-6 col-sm-6 col-md-6 text-right no_padding">
                           <img src="<?php echo get_bloginfo("stylesheet_directory");?>/images/icono-linea-transparencia-cordarien.png" class="img-responsive iconos_top">
		                   <a href="https://www.lineatransparencia.com/greenland" target="_blank"><span>Línea de transparencia<span></a>
		                </div>
		                <div class="col-xs-1 col-sm-1 col-md-1 no_padding text-center slash">
		                	<span>/</span>
		            	</div>
		                <div class="col-xs-5 col-sm-5 col-md-5 text-left no_padding">
		                	 <a href="https://sistema.etalento.co/aspirantes/formulario/to/CDD1" target="_blank"><span>Trabaje con nosotros</span></a>
		                </div>
	                </div>
	            </div>
	        </div>
        </div>
    </div>
    <header id="content_header">
        <div class="container no_padding">
            <div class="header_mobile">
                <a id="logo_mobile" alt="<?php echo get_bloginfo('name'); ?> | <?php bloginfo('description');?>" title="<?php echo get_bloginfo('name'); ?> | <?php bloginfo('description');?>" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <img src='<?php echo get_theme_mod("logo");?>' class="img-responsive" alt="<?php echo get_bloginfo('name'); ?>" title="<?php echo get_bloginfo('name'); ?>">
                </a>
                <button id="menu" class="off pull-right">
                    <div id="lineas_menu">
                        <span class="linea_menu linea_1"></span>
                        <span class="linea_menu linea_2"></span>
                        <span class="linea_menu linea_3"></span>
                    </div>
                </button>
                <nav id="access" class="col-centered">
                    <?php wp_nav_menu( array('theme_location' => 'primary','menu_class'=> 'menu_ppal',) ); ?>
                </nav>
                <!--<nav id="access" class="col-centered">
                    <?php wp_nav_menu( array('theme_location' => 'secondary','menu_class'=> 'menu_ppal',) ); ?>
                </nav> -->
                <div class="clear"></div>
            </div>
            <div class="header_pc">
                <a id="logo_menu" class="pull-left" alt="<?php echo get_bloginfo('name'); ?> | <?php bloginfo('description');?>" title="<?php echo get_bloginfo('name'); ?> | <?php bloginfo('description');?>" href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <img src='<?php echo get_theme_mod("logo");?>' class="img-responsive" alt="<?php echo get_bloginfo('name'); ?>" title="<?php echo get_bloginfo('name'); ?>">
                </a>
                <nav id="access" class="col-centered">
                    <?php wp_nav_menu( array('theme_location' => 'primary','menu_class'=> 'menu_ppal',) );?>
                </nav>
                <!--<nav id="access" class="col-centered">
                    <?php wp_nav_menu( array('theme_location' => 'secondary','menu_class'=> 'menu_ppal',) );?>
                </nav> -->
                <div class="clear"></div>
            </div>
        </div>
    </header>