$(document).ready(function() {
	$('input[name="nombre"]').attr('maxlength',  50);
    $('input[name="correo"]').attr('maxlength',  200);
    $('input[name="telefono"]').attr('maxlength',  20);
    $('input[name="pais"]').attr('maxlength',  60);
    $('textarea[name="asunto"]').attr('maxlength',  200);
    $('textarea[name="mensaje"]').attr('maxlength', 500);

	// boton - formulario contacto
  	$("#btn_form_cordarien").on("click", function () {
        $("#content_formulario").valid();
    });

	// validar que tipo de datos recibe el input
	jQuery.validator.addMethod("accept", function(value, element, param) {
  		return value.match(new RegExp("." + param + "$"));
	});
	// accept: "[a-zA-Z]+", por si las moscas pero mejor utilizar sincaracteres: true,
	// accept: "[0-9 áéíóúüñ]+",
	
    $.validator.addMethod("sincaracteres", function(value, element) {
        return /^[ a-z0-9áéíóúüñ,.]*$/i.test(value);
    }, "Ingrese sólo letras, números o espacios.");

	// validacion - formulario vida
	$("#content_formulario").validate({
        rules: {
            nombre: {
            	required: true,
            	maxlength: 50,
            },
            correo: {
            	required: true,
            	email:true,
            	maxlength: 29,
            },
            telefono: {
            	required: true,
            	maxlength: 20,
            },
            pais: {
            	required: true,
            	maxlength: 60,
            },
            mensaje: {
            	required: true,
            	maxlength: 500,
            	// sincaracteres: true,
            },
            
            // agregar al input la clase optional si hay campos que no se requieren
            highlight: function (element, errorClass, validClass) {
		        $(element).addClass(errorClass).removeClass(validClass);
		    },
		    unhighlight: function (element, errorClass, validClass) {
		        if ($(element).hasClass('optional') && $(element).val() == '') {
		            $(element).removeClass(errorClass).removeClass(validClass);
		        } else {
		            $(element).removeClass(errorClass).addClass(validClass);
		        }
		    },
        },


        submitHandler: function (form) {
            $.ajax({
				type: $(form).attr("method"),
				url: $(form).attr("action"),
				data: $(form).serialize(),
				success: function(){
					$("#exito").show("slide","slow");
					$("#content_formulario")[0].reset();
					setTimeout(function(){
					    $("#exito").hide("slide","slow");
					}, 5000);
				},
				error: function() {
					$("#fracaso").show("slide","slow");
					setTimeout(function(){
					    $("#fracaso").hide("slide","slow");
					}, 5000);
				}
			});
			return true;
        }

    });

});