<?php
/******* Register Custom Post Type == Banner *******/
if ( ! function_exists('banner_cpt') ) {
function banner_cpt() {
	$labels = array(
		'name'                  => 'Banner',
        'singular_name'         => 'Banner',
        'menu_name'             => 'Banner',
        'name_admin_bar'        => 'Banner',
        'archives'              => 'Banner',
        'attributes'            => 'Atributos del item',
        'parent_item_colon'     => 'Item padre:',
        'all_items'             => 'Todos los items',
        'add_new_item'          => 'Agregar una nuevo item',
        'add_new'               => 'Agregar un item',
        'new_item'              => 'Nuevo item',
        'edit_item'             => 'Editar item',
        'update_item'           => 'Actualizar item',
        'view_item'             => 'Ver item',
        'view_items'            => 'Ver items',
        'search_items'          => 'Buscar item',
        'not_found'             => 'No se encontró ningún item',
        'not_found_in_trash'    => 'No se encontró ningún item en la papelera',
        'featured_image'        => 'Imagen destacada del item',
        'set_featured_image'    => 'Subir imagen destacada del item',
        'remove_featured_image' => 'Remover imagen destacada del item',
        'use_featured_image'    => 'Usar como imagen destacada del item',
        'insert_into_item'      => 'Insertar en el item',
        'uploaded_to_this_item' => 'Cargar en este item',
        'items_list'            => 'lista de items',
        'items_list_navigation' => 'lista de navegación del item',
        'filter_items_list'     => 'Buscar item',
	);
	$rewrite = array(
		'slug'                  => 'banner',
		'with_front'            => true,
		'pages'                 => true,
		'feeds'                 => false,
	);
	$args = array(
		'label'                 => 'Banner',
		'description'           => 'Contenido del banner',
		'labels'                => $labels,
		'supports'              => array( 'thumbnail','title','editor'),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 10,
		'menu_icon'             => 'dashicons-images-alt2',
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,		
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'rewrite'               => $rewrite,
		'capability_type'       => 'page',
		'show_in_rest'          => true,
	);
	register_post_type( 'banner', $args );

}
add_action( 'init', 'banner_cpt', 0 );


/******* Crear Custom Fields == Campos personalizados (Banner - Imagen mobile) ******/
function custom_fields_banner_mobile() {
    add_meta_box('campos_custom_banner_mobile', 'Imagen banner Mobile', 'call_box_banner_mobile', 'banner', 'side', 'default');
}
add_action('add_meta_boxes', 'custom_fields_banner_mobile');

function call_box_banner_mobile($post){
	global $post;
	$img_banner_mobile = get_post_meta( $post->ID, 'img_banner_mobile', true );
	?>
	<div class="admin_right">
		<div class="custom_bg">
	        <input class="img_banner_mobile" type="hidden" id="img_banner_mobile" name="img_banner_mobile" value="<?php echo $img_banner_mobile;?>">
	        <?php if (isset($img_banner_mobile)){?>
	        <figure style="background-image: -webkit-linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4),-webkit-linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4); */background-image: linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4),linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4); background-position: 0 0,10px 10px; -webkit-background-size: 20px 20px;background-size: 20px 20px;">
	        	<img class="img-responsive src_img_banner_mobile" id="revome_img_banner_mobile" src="<?php echo $img_banner_mobile ;?>" style="width:100%;"/>
	        </figure>
	        <?php } ?>
	        <span class="separador"></span>
			<input class="upload_image_button button button-primary" name="up_img_banner_mobile" id="up_img_banner_mobile" type="button" value="Subir imagen" />
			<a href="#" class="remove-post-img" id="remove_btn_img_banner_mobile" style="display: none;">Remover</a>        
    	</div>
	</div>
	<?php
}

/******* Guardar Custom Fields == Campos personalizados (Banner - Imagen mobile) ******/
function save_box_img_banner_mobile($post_id) {   
	global $post;

	$old_img_banner_mobile = get_post_meta($post_id, 'img_banner_mobile', true);
	$img_banner_mobile     = sanitize_text_field($_POST['img_banner_mobile']);
	update_post_meta( $post_id, 'img_banner_mobile', $img_banner_mobile, $old_img_banner_mobile);
}
add_action('save_post', 'save_box_img_banner_mobile');

/******* Fin Banner - Crear Meta Box == Campos personalizados ******/

/****** Estructura Columnas CPT (Banner) ******/
function columnas_post_type_banner($columns) {
	$columns = array(
		'cb'                      => '<input type="checkbox" />',
		'img'                     => __('Imagen'),
		'title'                   => __('Título'),
		'date'                    => __('Fecha'),
	);
	return $columns;
}
add_filter('manage_edit-banner_columns', 'columnas_post_type_banner' ) ;


/****** Mostrar los datos a la Columna CPT (Banner) ******/
function filas_post_type_banner($column_name, $post_id){
	global $post;

	if($column_name == 'img'){?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>wp-admin/post.php?post=<?php the_ID(); ?>&action=edit"><?php echo get_the_post_thumbnail($post_id, array( 50, 50));?>
	</a>
    <?php }
}
add_action('manage_banner_posts_custom_column', 'filas_post_type_banner', 10, 2);
/******* Fin CPT *******/

}
?>