<?php
/******* Register Custom Post Type == Compromiso Ambiental *******/
if ( ! function_exists('compromiso_ambiental_cpt') ) {
function compromiso_ambiental_cpt() {
    $labels = array(
        'name'                  => 'Compromiso Ambiental',
        'singular_name'         => 'Compromiso Ambiental',
        'menu_name'             => 'Compromiso Ambiental',
        'name_admin_bar'        => 'Compromiso Ambiental',
        'archives'              => 'Compromiso Ambiental',
        'attributes'            => 'Atributos del item',
        'parent_item_colon'     => 'Item padre:',
        'all_items'             => 'Todos los items',
        'add_new_item'          => 'Agregar una nuevo item',
        'add_new'               => 'Agregar un item',
        'new_item'              => 'Nuevo item',
        'edit_item'             => 'Editar item',
        'update_item'           => 'Actualizar item',
        'view_item'             => 'Ver item',
        'view_items'            => 'Ver items',
        'search_items'          => 'Buscar item',
        'not_found'             => 'No se encontró ningún item',
        'not_found_in_trash'    => 'No se encontró ningún item en la papelera',
        'featured_image'        => 'Imagen destacada del item',
        'set_featured_image'    => 'Subir imagen destacada del item',
        'remove_featured_image' => 'Remover imagen destacada del item',
        'use_featured_image'    => 'Usar como imagen destacada del item',
        'insert_into_item'      => 'Insertar en el item',
        'uploaded_to_this_item' => 'Cargar en este item',
        'items_list'            => 'lista de items',
        'items_list_navigation' => 'lista de navegación del item',
        'filter_items_list'     => 'Buscar item',
    );
    $rewrite = array(
        'slug'                  => 'compromiso-ambiental',
        'with_front'            => true,
        'pages'                 => true,
        'feeds'                 => false,
    );
    $args = array(
        'label'                 => 'Compromiso Ambiental',
        'description'           => 'Contenido Compromiso Ambiental',
        'labels'                => $labels,
        'supports'              => array( 'thumbnail','title','editor'),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 14,
        'menu_icon'             => 'dashicons-buddicons-buddypress-logo',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,        
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'rewrite'               => $rewrite,
        'capability_type'       => 'page',
        'show_in_rest'          => true,
    );
    register_post_type( 'compromiso-ambiental', $args );

}
add_action( 'init', 'compromiso_ambiental_cpt', 0 );


/****** Estructura Columnas CPT (compromiso Ambiental) ******/
function columnas_post_type_compromiso_ambiental($columns) {
    $columns = array(
        'cb'                       => '<input type="checkbox" />',
        'img'                      => __('Imagen'),
        'title'                    => __('Título'),
        'date'                     => __('Fecha'),
    );
    return $columns;
}
add_filter('manage_edit-compromiso_ambiental_columns', 'columnas_post_type_compromiso_ambiental' ) ;


/****** Mostrar los datos a la Columna CPT (compromiso Ambiental) ******/
function filas_post_type_compromiso_ambiental($column_name, $post_id){
    global $post;

    if($column_name == 'img'){?>
    <a href="<?php echo esc_url( home_url( '/' ) ); ?>wp-admin/post.php?post=<?php the_ID(); ?>&action=edit"><?php echo get_the_post_thumbnail($post_id, array( 50, 50));?>
    </a>
    <?php }

}
add_action('manage_compromiso_ambiental_posts_custom_column', 'filas_post_type_compromiso_ambiental', 10, 2);
/******* Fin CPT *******/


/******* Crear Custom Fields == Campos personalizados (Color) ******/
function custom_fields_color_compromiso_ambiental() {
    add_meta_box('campos_custom_color_logros', 'Color Fondo', 'call_box_color_compromiso_ambiental', 'compromiso-ambiental', 'side', 'default');
}
add_action('add_meta_boxes', 'custom_fields_color_compromiso_ambiental');

function call_box_color_compromiso_ambiental($post){
    global $post;
    $color  = get_post_meta($post->ID, 'color', true);
    $color  = ( ! empty( $color ) ) ? "{$color}" : '#000';

    ?>
    <div class="admin_right">
        <div class="custom_bg">
            <input class="color" type="text" name="color" value="<?php echo $color; ?>"  />     
        </div>
    </div>
    <?php
}

/******* Guardar Custom Fields == Campos personalizados (Color) ******/
function save_box_color_compromiso_ambiental($post_id) {   
    global $post;

    if ($post){
        update_post_meta($post->ID, "color", @$_POST["color"]);
    }
}
add_action('save_post', 'save_box_color_compromiso_ambiental');


}
?>