<?php
/******* Register Custom Post Type == Productos *******/
if ( ! function_exists('productos_cpt') ) {
function productos_cpt() {
    $labels = array(
        'name'                  => 'Productos',
        'singular_name'         => 'Productos',
        'menu_name'             => 'Productos',
        'name_admin_bar'        => 'Productos',
        'archives'              => 'Productos',
        'attributes'            => 'Atributos del item',
        'parent_item_colon'     => 'Item padre:',
        'all_items'             => 'Todos los items',
        'add_new_item'          => 'Agregar una nuevo item',
        'add_new'               => 'Agregar un item',
        'new_item'              => 'Nuevo item',
        'edit_item'             => 'Editar item',
        'update_item'           => 'Actualizar item',
        'view_item'             => 'Ver item',
        'view_items'            => 'Ver items',
        'search_items'          => 'Buscar item',
        'not_found'             => 'No se encontró ningún item',
        'not_found_in_trash'    => 'No se encontró ningún item en la papelera',
        'featured_image'        => 'Imagen destacada del item',
        'set_featured_image'    => 'Subir imagen destacada del item',
        'remove_featured_image' => 'Remover imagen destacada del item',
        'use_featured_image'    => 'Usar como imagen destacada del item',
        'insert_into_item'      => 'Insertar en el item',
        'uploaded_to_this_item' => 'Cargar en este item',
        'items_list'            => 'lista de items',
        'items_list_navigation' => 'lista de navegación del item',
        'filter_items_list'     => 'Buscar item',
    );
    $rewrite = array(
        'slug'                  => 'productos',
        'with_front'            => true,
        'pages'                 => true,
        'feeds'                 => false,
    );
    $args = array(
        'label'                 => 'Productos',
        'description'           => 'Contenido Productos',
        'labels'                => $labels,
        'supports'              => array( 'thumbnail','title','editor'),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 11,
        'menu_icon'             => 'dashicons-products',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,        
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'rewrite'               => $rewrite,
        'capability_type'       => 'page',
        'show_in_rest'          => true,
    );
    register_post_type( 'productos', $args );

}
add_action( 'init', 'productos_cpt', 0 );


/******* Register Taxonomy == (Tipos de Productos) en CPT ******/
if ( ! function_exists( 'tipos_producto_taxonomy' ) ) {
function tipos_producto_taxonomy() {
    $labels = array(
        'name'                       => 'Tipos de productos',
        'singular_name'              => 'Tipos de productos',
        'menu_name'                  => 'Tipos de productos',
        'all_items'                  => 'Todos los tipos de productos',
        'parent_item'                => 'Superior',
        'parent_item_colon'          => 'Superior:',
        'new_item_name'              => 'Nuevo tipo de producto',
        'add_new_item'               => 'Agregar un tipo de producto',
        'edit_item'                  => 'Editar tipo de producto',
        'update_item'                => 'Actualizar tipo de producto',
        'view_item'                  => 'Ver tipos de productos',
        'separate_items_with_commas' => 'Separar tipos de productos con comas',
        'add_or_remove_items'        => 'Agregar y eliminar tipo de producto',
        'choose_from_most_used'      => 'Seleccionar tipos de productos más usadas',
        'popular_items'              => 'tipos de productos más populares',
        'search_items'               => 'Buscar tipo de producto',
        'not_found'                  => 'No se encontraron tipos de productos',
        'no_terms'                   => 'No existen tipos de productos',
        'items_list'                 => 'Lista de tipos de productos',
        'items_list_navigation'      => 'Lista de navegación de tipo de producto',
    );
    $rewrite = array(
        'slug'                       => '',
        'with_front'                 => true,
        'hierarchical'               => true,
    );
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => false,
        'rewrite'                    => $rewrite,
        'show_in_rest'               => true,
    );
    register_taxonomy('tipos-productos', array('productos'), $args);

}
add_action('init', 'tipos_producto_taxonomy', 0);
}


/****** Estructura Columnas CPT (Productos) ******/
function columnas_post_type_productos($columns) {
    $columns = array(
        'cb'                       => '<input type="checkbox" />',
        'img'                      => __('Imagen'),
        'title'                    => __('Título'),
        'taxonomy-tipos-productos' => __('Tipos de productos'),
        'date'                     => __('Fecha'),
    );
    return $columns;
}
add_filter('manage_edit-productos_columns', 'columnas_post_type_productos' ) ;


/****** Mostrar los datos a la Columna CPT (Productos) ******/
function filas_post_type_productos($column_name, $post_id){
    global $post;

    if($column_name == 'img'){?>
    <a href="<?php echo esc_url( home_url( '/' ) ); ?>wp-admin/post.php?post=<?php the_ID(); ?>&action=edit"><?php echo get_the_post_thumbnail($post_id, array( 50, 50));?>
    </a>
    <?php }

}
add_action('manage_productos_posts_custom_column', 'filas_post_type_productos', 10, 2);
/******* Fin CPT *******/

/******* Inicio Taxonomia - Crear Meta Box == Campos personalizados (Tipos de productos Taxonomy) ******/
function meta_box_tipos_productos(){
    add_meta_box('campos_tax', 'Información de los tipos de productos', 'call_tax_tipos_productos', 'productos', 'normal', 'default');
}
add_action('add_meta_boxes_tipos_productos', 'meta_box_tipos_productos');

function call_tax_tipos_productos($term){
    $icono_category          = get_term_meta($term->term_id,'icono_category',true);
    $background_img_category = get_term_meta($term->term_id,'background_img_category',true);
    $banner_img_category     = get_term_meta($term->term_id,'banner_img_category',true);
    ?>
    <tr class="form-field term-icono_category-wrap">
        <th scope="col"><label for="icono_category">Icono de la cátegoria</label></th>
        <td>
            <input class="item_input icono_category" type="hidden" id="icono_category" name="icono_category" value="<?php echo $icono_category;?>">
            <?php if (isset($icono_category)){?>
            <figure style="width: 95%;background-image: -webkit-linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4),-webkit-linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4); */background-image: linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4),linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4); background-position: 0 0,10px 10px; -webkit-background-size: 20px 20px;background-size: 20px 20px;">
                <img class="img-responsive src_icono_category" id="revome_icono_category" src="<?php echo $icono_category ;?>" style="width:60%;margin:auto;"/>
            </figure>
            <?php } ?>
            <span class="separador"></span>
            <input class="upload_image_button button button-primary" name="up_icono_category" id="up_icono_category" type="button" value="Subir imagen" />
            <a href="#" class="remove-post-img" id="remove_btn_icono_category" style="display: none;">Remover</a>
        </td>
    </tr>
    <tr class="form-field term-background_img_category-wrap">
        <th scope="col"><label for="background_img_category">Background de la cátegoria</label></th>
        <td>
            <input class="item_input background_img_category" type="hidden" id="background_img_category" name="background_img_category" value="<?php echo $background_img_category;?>">
            <?php if (isset($background_img_category)){?>
            <figure style="width: 95%;background-image: -webkit-linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4),-webkit-linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4); */background-image: linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4),linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4); background-position: 0 0,10px 10px; -webkit-background-size: 20px 20px;background-size: 20px 20px;">
                <img class="img-responsive src_background_img_category" id="revome_background_img_category" src="<?php echo $background_img_category ;?>" style="width:60%;margin:auto;"/>
            </figure>
            <?php } ?>
            <span class="separador"></span>
            <input class="upload_image_button button button-primary" name="up_background_img_category" id="up_background_img_category" type="button" value="Subir imagen" />
            <a href="#" class="remove-post-img" id="remove_btn_background_img_category" style="display: none;">Remover</a>
        </td>
    </tr>
    <tr class="form-field term-banner_img_category-wrap">
        <th scope="col"><label for="banner_img_category">Banner de la cátegoria</label></th>
        <td>
            <input class="item_input banner_img_category" type="hidden" id="banner_img_category" name="banner_img_category" value="<?php echo $banner_img_category;?>">
            <?php if (isset($banner_img_category)){?>
            <figure style="width: 95%;background-image: -webkit-linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4),-webkit-linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4); */background-image: linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4),linear-gradient(45deg,#c4c4c4 25%,transparent 25%,transparent 75%,#c4c4c4 75%,#c4c4c4); background-position: 0 0,10px 10px; -webkit-background-size: 20px 20px;background-size: 20px 20px;">
                <img class="img-responsive src_banner_img_category" id="revome_banner_img_category" src="<?php echo $banner_img_category ;?>" style="width:60%;margin:auto;"/>
            </figure>
            <?php } ?>
            <span class="separador"></span>
            <input class="upload_image_button button button-primary" name="up_banner_img_category" id="up_banner_img_category" type="button" value="Subir imagen" />
            <a href="#" class="remove-post-img" id="remove_btn_banner_img_category" style="display: none;">Remover</a>
        </td>
    </tr> 
    <?php
}
add_action('tipos-productos_edit_form_fields', 'call_tax_tipos_productos'); 


/******* Guardar Meta Box == Campos personalizados (Tipos de productos Taxonomy) ******/
function tax_box_save_tipos_productos($term_id){  
    $old_icono_category = get_term_meta($term_id,'icono_category',true);
    $icono_category     = sanitize_text_field($_POST['icono_category']);
    update_term_meta($term_id,'icono_category', $icono_category,$old_icono_category);

    $old_background_img_category = get_term_meta($term_id,'background_img_category',true);
    $background_img_category     = sanitize_text_field($_POST['background_img_category']);
    update_term_meta($term_id,'background_img_category', $background_img_category,$old_background_img_category);

    $old_banner_img_category = get_term_meta($term_id,'banner_img_category',true);
    $banner_img_category     = sanitize_text_field($_POST['banner_img_category']);
    update_term_meta($term_id,'banner_img_category', $banner_img_category,$old_banner_img_category);
}
add_action('edit_tipos-productos', 'tax_box_save_tipos_productos');


/******* Inicio filtros postype y taxonomy - Mostrar un menú desplegable de taxonomía personalizada en admin. *******/
function filter_post_type_by_taxonomy_productos($post_type, $which){
    if('productos' !== $post_type){
        return; // verifique el nombre del post type
    }
    $taxonomy_slug = 'tipos-productos';
    $taxonomy = get_taxonomy($taxonomy_slug);
    $selected = '';
    $request_attr = 'filtro-productos'; // texto de la consulta url
    if ( isset($_REQUEST[$request_attr])){
      $selected = $_REQUEST[$request_attr]; // en caso de que la pagina ya este filtrada no recargar
    }
    wp_dropdown_categories(array(
        'show_option_all' =>  __("{$taxonomy->label}"),
        'taxonomy'        =>  $taxonomy_slug,
        'name'            =>  $request_attr,
        'orderby'         => 'id',
        'selected'        =>  $selected,
        'hierarchical'    =>  true,
        'depth'           =>  3,
        'show_count'      =>  true, // Mostrar el número de publicaciones en el término principal
        'hide_empty'      =>  false, // No mostrar publicaciones sin términos

    ));
}
add_action('restrict_manage_posts','filter_post_type_by_taxonomy_productos',10,2);


/******* Filtrar publicaciones por taxonomía en administración *******/ 
function filter_request_query_productos($query){
    // modifique la consulta solo si es admin y consulta principal.
    if(!(is_admin() AND $query->is_main_query())){ 
      return $query;
    }
    // modificar la consulta para la publicación personalizada dirigida.
    if('productos' !== $query->query['post_type']){
      return $query;
    }
    // tipo de filtro
    if(isset($_REQUEST['filtro-productos']) &&  0 != $_REQUEST['filtro-productos']){
      $term =  $_REQUEST['filtro-productos'];
      $taxonomy_slug = 'tipos-productos';
      $query->query_vars['tax_query'] = array(
        array(
            'taxonomy'  => $taxonomy_slug,
            'field'     => 'ID',
            'terms'     => array($term)
        )
      );
    }
    return $query;
}
add_filter('parse_query', 'filter_request_query_productos' , 10);
/******* Fin filtros postype y taxonomy*******/

}
?>